/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MenuItem
extends MenuComponent {
    boolean enabled = true;
    String label;
    String actionCommand;
    long eventMask;
    transient ActionListener actionListener;
    private MenuShortcut shortcut;
    private static final String base = "menuitem";
    private static int nameCounter;
    private static final long serialVersionUID = -21757335363267194L;
    private int menuItemSerializedDataVersion = 1;

    public MenuItem() {
        this("", null);
    }

    public MenuItem(String string) {
        this(string, null);
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.label = string;
        this.shortcut = menuShortcut;
    }

    String constructComponentName() {
        return base + nameCounter++;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
            }
            return;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(string);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public synchronized void enable() {
        this.enabled = true;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.enable();
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
            return;
        }
        this.disable();
    }

    public synchronized void disable() {
        this.enabled = false;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.disable();
        }
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        this.shortcut = menuShortcut;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(this.label);
        }
    }

    public void deleteShortcut() {
        this.shortcut = null;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(this.label);
        }
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        if (menuShortcut.equals(this.shortcut)) {
            this.shortcut = null;
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            if (menuItemPeer != null) {
                menuItemPeer.setLabel(this.label);
            }
        }
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        MenuShortcut menuShortcut = new MenuShortcut(keyEvent.getKeyCode(), (keyEvent.getModifiers() & 1) > 0);
        if (menuShortcut.equals(this.shortcut) && this.enabled) {
            if (keyEvent.getID() == 401) {
                Toolkit.getEventQueue().postEvent(new ActionEvent(this, 1001, this.actionCommand));
            }
            return true;
        }
        return false;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        if (menuShortcut.equals(this.shortcut)) {
            return this;
        }
        return null;
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        this.newEventsOnly = true;
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return this.label;
        }
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public String paramString() {
        String string = ",label=" + this.label;
        if (this.shortcut != null) {
            string = String.valueOf(string) + ",shortcut=" + this.shortcut;
        }
        return String.valueOf(super.paramString()) + string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "actionL") {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

