package reflection;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
public final class ExampleTest {
    @Test
    public static void testXXX() {
        final String xxx = "XXX";
        log(xxx);
    }

    @Test
    public static void testYYY() {
        log("YYY");
    }

    private static void log(final String test) {
        System.out.println("\ttest" + test);
    }

    @Test
    public static void testThrows() {
        throw new RuntimeException("testThrows");
    }

    @Test
    public void testNonStatic() {
        log("NonStatic");
    }

    public static void testWithArguments(final int hello) {
        log("WithArguments " + hello);
    }


    @Test
    void testPrivate() {
        log("private");
    }
}
