package examples.net.udp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

/**
 * Created by IntelliJ IDEA.
 * User: geo
 * Date: 28.04.2010
 * Time: 8:06:32
 * To change this template use File | Settings | File Templates.
 */
public class DNSClient {
    public static void main(String[] args) throws IOException, InterruptedException {
        byte[] query = DNS.createQuery(123, "www.ifmo.ru", 2);

        final DatagramSocket socket = new DatagramSocket(12345);
        final DatagramPacket request = new DatagramPacket(query, 0, query.length);
        request.setAddress(InetAddress.getByName("dnscache1.spbnit.ru"));
        request.setPort(53);

        socket.send(request);

        final DatagramPacket response = new DatagramPacket(new byte[1024], 0, 1024);
        socket.receive(response);

        final DNSResponse dnsResponse = new DNSResponse(response.getData(), response.getOffset(), response.getLength());
        System.out.println(dnsResponse);
    }
}
